pico-8 cartridge // http://www.pico-8.com
version 18
__lua__
--puroresu no seishin
--by jumalauta

#include include\chance100.lua
#include include\dot3d_rotate.lua
#include include\flatten_point.lua
#include include\round.lua
#include include\parse_table.lua
#include include\rle_decomp.lua
#include include\huffman_decomp.lua
#include include\copy.lua
#include include\trifill.lua
#include include\flat_trifill.lua
#include include\send_to_queue.lua
#include include\rotate.lua
#include include\translate.lua
#include include\render_queue.lua
#include include\unpack_object.lua
#include include\generate_gradient.lua
#include include\mem_to_str.lua
#include include\str_to_mem.lua
#include include\str_to_mem_call.lua
#include include\hex_to_dec.lua
   
function create_anim(packed_anim)

 anim,frame,i,sprite,text_prep={{}},{},1,{},{}
 
 local n=1
 
 while n<=#packed_anim do
 
  char=sub(packed_anim,n,n+1)

  if char=="ff" then

   add(anim[i],frame)
   frame={}
   
   if #anim[i]==5 then
    text_prep[i]=false
	i+=1
	anim[i]={}	
   end
   
  else
  
   add(sprite,hex_to_dec(char,1,1))
   if #sprite==7 then
    add(frame,sprite)
	sprite={}
   end
   
  end
  
  n+=2
  
 end
 
 return anim
 
end
 
function satellite_2d(dist,q)
 return dist*cos(q),dist*sin(q)
end
 
function dummy_cor()
end

function mand_prep_next_frame()
 for prep_y=1,32 do
  for prep_x=1,64 do
   poke(0x42bf+prep_y*64+prep_x,mand_keyframes[n][prep_y][prep_x])
  end
 end
end

function generate_mand_keyframes()

 for mand_n=1,35 do
 
  mand_xstab,mand_scanchunk,mand_keyframes[mand_n],mand_zoom={},{},{},64*mand_path[mand_n][1]

  for mand_x=1,128 do
   add(mand_xstab,mand_path[mand_n][2]+(mand_x-129)/mand_zoom)
  end
    
  for mand_yp=0,31 do
   mand_ys,mand_scanline=mand_yp/mand_zoom,{}
   for mand_xp=0,127 do
    mand_xs,mand_x,mand_y,mand_z,mand_i=mand_xstab[mand_xp+1],0,0,0,0
    while mand_x+mand_y<=4 and mand_i<42 do
     mand_xt,mand_yt=mand_x-mand_y+mand_xs,mand_z-mand_x-mand_y+mand_ys
     mand_x,mand_y,mand_z=mand_xt^2,mand_yt^2,(mand_xt+mand_yt)^2
     mand_i+=1
    end
    add(mand_scanchunk, mand_i%7)
    if #mand_scanchunk==2 then
     add(mand_scanline, mand_scanchunk[1]+16*mand_scanchunk[2])
     mand_scanchunk={}
    end
   end
   add(mand_keyframes[mand_n],mand_scanline)
  end
 
 end

end

function _init()

 shades=parse_table("0b1000000000000.0000000000000000_0b1000000000000.1000000000000000_0b1000000000000.1000000000100000_0b1000000000000.1010000000100000_0b1000000000000.1010000010100000_0b1000000000000.1010010010100000_0b1000000000000.1010010010100001_0b1000000000000.1010010110100001_0b1000000000000.1010010110100101_0b1000000000000.1110010110100101_0b1000000000000.1110010110110101_0b1000000000000.1111010110110101_0b1000000000000.1111010111110101_0b1000000000000.1111110111110101_0b1000000000000.1111110111110111_0b1000000000000.1111111111110111|")

 linestr,line_index,lines,linemods,cooldown,mand_path,mand_keyframes,mandtext,mand_text_prepped,scene_itd,spr_plasma_picture,spr_greets,obj_belt_packed,obj_foreign_packed,flower_grad,plasma_flashes,flowerpix_set,titlescroll_lines,titlepatterns,snapshots,spr_plasma_text,circles,circles_free,snapshot_timer,snapshot_display_timer,fg_red_gradient,fg_blue_gradient,script,logoanim,logoparams,scn2_texts,pals,rowwidths,plasmaedgetimer="123121121321321323323123143141141341341343343143567565565765765767767567587585585785785787787587597595595795795797797597143163141161341361343363163567161565361765363767183587181585381785383787193597191595391795393797",parse_table("-2_0_2_0.525_-1.8_-0.9_1.8_-0.6_-0.3|"),{},parse_table("0_0_-0.39|-0.27_0_0|0_0_0.37|-0.79_0_0|0_0_-0.12|0.82_0_0|0_0_-0.35|-0.44_0_0|0_0_-0.46|-0.01_0_0|0_0_0.9|0.15_0_0|0_0_0.42|-0.58_0_0|0_0_-0.99|0.06_0_0|0_0_0.82|-0.48_0_0|0_0_0.48|-0.2_0_0|0_0.52_0|0_-0.74_0|0_0.31_0|0_-0.73_0|-1_0_1|-1_0_-1|1_0_-1|1_0_1|-1_0_1|-1_0_-1|1_0_-1|1_0_1|-1_0_1|-1_0_-1|1_0_-1|1_0_1|"),0,parse_table("0.2_4.75_0|0.2461_3.8128_12|0.3029_2.9242_10|0.3728_2.0991_8|0.4589_1.3866_7|0.5648_0.8077_7|0.6951_0.3651_8|0.8555_0.0054_8|1.0529_-0.3051_7|1.2959_-0.5722_6|1.595_-0.8013_5|1.9631_-0.9972_4|2.4162_-1.1644_3|2.9738_-1.3066_2|3.6604_-1.417_3|4.5054_-1.5024_4|5.5454_-1.5683_5|6.8252_-1.6191_6|8.402_-1.658_7|10.3434_-1.6878_8|12.7304_-1.7105_9|15.671_-1.7277_10|19.298_-1.7407_11|23.7621_-1.7504_12|29.2571_-1.7577_13|36.0088_-1.763_14|44.341_-1.767_15|54.6133_-1.7698_16|67.2854_-1.7718_17|82.957_-1.7733_18|102.4_-1.7744_18|126.0308_-1.7755_17|155.2986_-1.7765_16|191.6257_-1.7774_15|237.4493_-1.7783_14|"),{},parse_table("661_3520|667_4544|672_5568|683_6592|"),false,{true},{},{},{},{{},{},{},{}},generate_gradient(parse_table("0_32_64_96|"),4),parse_table("627_638_649_682|"),{},{parse_table("128_96_160_96|160_96_192_64|192_64_192_32|192_32_160_32|160_32_160_64|160_64_128_64|128_64_128_96|200_32_200_96|200_96_248_96|248_96_264_80|264_80_264_32|264_32_232_64|232_64_232_32|232_32_200_32|272_96_272_64|272_64_304_32|304_32_304_64|304_64_336_32|336_32_336_96|336_96_272_96|344_96_408_32|408_32_408_96|408_96_344_96|416_32_416_96|416_96_480_96|480_96_480_64|480_64_448_64|448_64_448_32|448_32_416_32|488_96_552_32|552_32_552_96|552_96_488_96|560_32_560_96|560_96_608_96|608_96_624_80|624_80_624_32|624_32_592_64|592_64_592_32|592_32_560_32|632_32_696_32|696_32_696_96|696_96_632_32|704_96_768_32|768_32_768_96|768_96_704_96|"),parse_table("128_48_128_80|128_48_160_48|160_48_144_64|144_64_144_80|144_80_128_80|164_48_164_80|164_80_188_80|188_80_196_72|196_72_196_48|196_48_180_64|180_64_180_48|180_48_164_48|200_48_200_80|200_80_232_48|232_48_200_48|216_64_232_64|232_64_216_80|216_80_216_64|244_48_268_48|268_48_268_72|268_72_260_80|260_80_236_80|236_80_236_56|236_56_244_48|272_48_272_80|272_80_304_48|304_48_272_48|288_64_304_64|304_64_288_80|288_80_288_64|308_48_308_72|308_72_316_80|316_80_340_80|340_80_340_48|340_48_308_48|340_59_324_59|340_69_324_69|352_48_376_48|376_48_344_80|344_64_344_56|344_56_352_48|344_80_368_80|368_80_376_72|376_72_376_64|376_64_344_64|380_48_380_80|380_80_404_80|404_80_412_72|412_72_412_48|412_48_396_64|396_64_396_48|396_48_380_48|428_48_428_80|428_80_444_80|444_48_460_48|460_48_460_80|428_48_460_80|444_48_444_80|472_48_496_48|496_48_496_72|496_72_488_80|488_80_464_80|464_80_464_56|464_56_472_48|520_48_544_48|544_48_512_80|512_64_512_56|512_56_520_48|512_80_536_80|536_80_544_72|544_72_544_64|544_64_512_64|548_48_548_72|548_72_556_80|556_80_580_80|580_80_580_48|580_48_548_48|580_59_564_59|580_69_564_69|584_48_600_48|600_48_600_80|600_80_584_80|584_80_584_48|612_48_636_48|636_48_604_80|604_64_604_56|604_56_612_48|604_80_628_80|628_80_636_72|636_72_636_64|636_64_604_64|640_80_640_56|640_56_648_48|648_48_672_48|672_48_672_72|672_72_664_80|664_80_640_80|656_48_656_59|656_69_656_80|676_48_692_48|692_48_692_80|692_80_676_80|676_80_676_48|696_48_696_80|696_80_712_80|712_48_728_48|728_48_728_80|696_48_728_80|712_48_712_80|")},generate_gradient(parse_table("0_32_64_96|"),0),{},{},{},{},parse_table("1_352|2_1496|3_350|4_203|4_379|4_555|5_11|5_659|6_176|6_528|7_46|7_222|7_398|7_574|8_1|9_46|9_222|9_398|9_574|10_616|10_649|10_682|"),parse_table("979_990_1001_1034_1067_1078_1089_1122_1155_1166_1177_1210|"),generate_gradient(parse_table("0_66_89_113|"),0),generate_gradient(parse_table("0_47_95_110_124|"),0),parse_table("0_4_13_17_21_25_29_33_41_45_52|"),{},parse_table("0_0_0_0_112_54_12_40|8_4_0_0_112_54_9_38|15_9_0_0_112_54_9_37|"),parse_table("0_704_100_91_18_-1_57|0_704_107_69_29_1_64|704_1408_114_70_29_-1_57|704_1408_121_101_13_1_64|"),parse_table("0080850585860d068009070b82028809_0081050600050607800907ff82028809_000506070085860f8009070882028809_000506070085860f8009070882028809|"),parse_table("66_78|52_52|75_54|103_96|"),parse_table("0_15|-22_11|-55_7|-66_3|")

 cor,cor2=cocreate(generate_mand_keyframes),cocreate(dummy_cor) 
 
 for i=1,256 do
  add(scene_itd,false)
  add(circles,{x=rnd(128),y=rnd(128),r=0xffff})
  add(circles_free,i)
  add(logoanim,{})
 end

 for i=1,216,6 do
  newline={}
  for j=0,3,3 do
   newcoord={}
   for k=0,2 do
    n=i+j+k
    add(newcoord,line_index[sub(linestr,n,n)+0])
   end
   add(newline,newcoord)
  end
  add(lines,newline)
 end

 memset(0x5f10,129,16) 

 poke(0x5f34,1)
 
 cls() 
 
 while #mand_keyframes<22 do
  coresume(cor)
 end

 function pad_asset(asset,nibble,left,middle,right)
 
  function generate_padstring(n)
   padstr=""
   while #padstr<n do
    padstr=padstr..nibble
   end
   return padstr
  end
  
  str,i="",1
  
  while i<#asset do
   str=str..generate_padstring(left)..sub(asset,i,i+middle-1)..generate_padstring(right)
   i+=middle
  end
  
  return str
  
 end
 
 function unpack_asset(asset_index)  

  current_asset=asset_list[asset_index]
  
  if current_asset==nil then
   return
  end

  asset,data=sub(data,1,current_asset[1]),sub(data,current_asset[1]+1)

  if current_asset[2]==1 then asset=huffman_decomp(asset) end
  if current_asset[3]==1 then asset=rle_decomp(asset) end
  
  if #current_asset>3 then

   params=current_asset

   asset=pad_asset(asset,recursify(4,7))
  end
  
  if asset_index<=#asset_list then
   return asset,unpack_asset(asset_index+1)
  end

 end 

#include loader.p8l

 str_to_mem_call(0x3100,soundtrack)
 
 for i=1,2 do
  n=i
  mand_prep_next_frame()
  memcpy(0,0x0800,2048)
  memcpy(0x0800,0x4300,2048)
 end
 
 zoomseg=mand_path[2][3]
 
 mandelbrot_zoom(0)
 
 clip()
 
 for y=1,29 do
  memcpy(0x7000-y*64,0x7000+y*64,64)
 end
 
 memcpy(0x1000,0x6800,4096) 

 asset_list,data,soundtrack,obj_belt,obj_foreign,n,lasers,strobes,strobepattern,mand_flashes,mandpals,greets_refresh,shadetab,newsprites,spr_greets,textrefresh,textnum,texts,overlay_params,anim,spr_plasma_picture[4],trans=nil,nil,nil,unpack_object(obj_belt_packed),{},1,{},parse_table("1_12_23_34_45_56_67_78_89_100_111_122_133_144_155_166_188_221_227_232_276_309_315_320|"),{},{},parse_table("0_1_2_12_14_15_17|0_1_2_8_9_10_15|0_1_2_12_14_15_17|0_1_2_8_9_10_15|"),0,{},parse_table("616_627_649_682|"),{},0,1,parse_table("high fly_flow|rainmaker|tiger_driver_91|bomaye|"),parse_table("0_78_78_40|0_93_51_80|176_78_105_65|352_78_51_20|352_93_63_37|352_108_21_54|528_78_75_80|"),create_anim(anim1),mem_to_str(4032,4160),parse_table("-1_0_-3.5|0_0_-7|1_2_-6|0_0_-10|")
 
 str_to_mem_call(0,spr_greets_en..spr_greets_jp)
 memcpy(0x6000,0,8192)
 
 for i=0,7 do
  cls()
  memcpy(0x6000,2560+i*640,640)
  sspr(0,i*5,64,5,0,0)
  add(spr_greets,mem_to_str(0x6000,640))
 end

 for obj in all(obj_foreign_packed) do add(obj_foreign, unpack_object(obj)) end

 for i=1,4 do
  add(shadetab,{})
  for p=1,64 do
   add(shadetab[i],mid(0,-7,-7-flr(14*sin(((p-33)/32+i*0.25)%1))))
  end
 end

 for i=1,5 do
  add(lasers,{value=0})
 end

 for i in all(strobes) do
  strobepattern[i]=true
 end
 
 for i=1,352 do
  add(mand_flashes,0)
 end
 for i=1,8 do
  for j=1,6 do
   mand_flashes[i*44-j-16],mand_flashes[171-j]=j,j
  end
 end 
 
 str_to_mem_call(0x6000,spr_logo_mask)
 
 for x=0,112 do
  for y=0,54 do
   function create_logoanim(a,b)
    if pget(x,y+a)!=0 then add(logoanim[pget(x,y+a)+b],{x,y}) end
   end
   create_logoanim(0,0)
   create_logoanim(54,15)
  end
 end

 cls()
 memset(0,0,8192)
 str_to_mem_call(0,spr_warning_jp)
 str_to_mem_call(2304,spr_warning_en)

 music()
 
 scn,snapshots_taken,snapflash_counter,lagcheck,f,f2,snapshot_drawn=1,0,0,false,0,0,{}
 
end

#include puro\scene_inits.lua

function _update60()

 inits={nil,initscene2,initscene3,initscene4,initscene5,initscene6,initscene7,initscene8,initscene9,initscene10,initscene11}
 
 for k,v in pairs(script) do if stat(24)>=v then scn=k end end
 
 if scn==2 and f>1377 and f<1408 then
  for p in all(logoanim[f-1377]) do
   sset(p[1],p[2],15)
  end
 end
  
 if scene_itd[scn]==false then
  cls()
  pal()
  inits[scn]()
  f,scene_itd[scn]=0,true
 end
 
 f+=1
 f2+=1

 est_f=flr(((stat(24)-script[scn])*351+stat(26))/2.0026)
 if lagcheck==true and f<est_f and est_f<f+5 then f=est_f end
 
 cooldown-=1

end

#include puro\draw_opening_text.lua
#include puro\draw_burning_ring.lua
#include puro\draw_flower.lua
#include puro\draw_plasma.lua
#include puro\draw_mandeltwister.lua
#include puro\draw_foreign_objects.lua
#include puro\draw_finisher_anims.lua
#include puro\draw_greetings.lua
#include puro\draw_titlescroll.lua
#include puro\draw_farjanclub.lua

function _draw()

 rq={{},{}}

 cls()
 
  scene={
   draw_opening_text,
   draw_burning_ring,
   draw_flower,
   draw_plasma,
   draw_mandeltwister,
   draw_foreign_objects,
   draw_finisher_anims,
   draw_greetings,
   draw_finisher_anims,
   draw_titlescroll,
   draw_farjanclub
  }
  scene[scn]()
 
 if cooldown<0 then
    
  coresume(cor)
  coresume(cor2)  
  
  if cor_mand_prep then coresume(cor_mand_prep) end
  
 end

 for k,v in pairs(snapshot_timer) do
  if scn==v[1] and f>=v[2] and snapshots_taken<k then
   snapshots_taken,snapflash_counter,snapprob=k,50+rnd(150),100
   if scn==7 or scn==9 then snapprob=33 end
   if chance100(snapprob) then
    add(snapshots,{mem_to_str(0x6000+flr(rnd(32))*64,0x1800),mem_to_str(0x5f10,16)})
	add(snapshot_drawn, false)
   end
  end
 end
 
 if snapflash_counter>1 then
  for i=1,snapflash_counter do
   if scn!=8 then pal(flr(rnd(16)),5+rnd(3),1) end
  end
  snapflash_counter*=0.7
 end

 if stat(7)<60 then
  cooldown=5
 end

end

__gfx__
1f1f1675f1f89c148f8f49f1f8f8f1f1f1019a84e7f3f4f1f1b1a1f2f1f1b1a11211841992b0d3177f8a8029321219227cff607cff2c1e7504e28ad2ede07d4b
96dc80f75eb163dac7905cff2f7ebf64f9080100ffff2b40500764f9fdd2fb1017bdb6e87dd06ab9a4966b7dd55b6c1e4b6bad965b7c966a9a5a5b3cd6eafb96
daaa160714acabae284d718760cfb1a5aaabcff6688fce91ebc323ebaaffde434310fac9a6d767ddffc96e83c07738b7aebaef0df0000cbf6baeab8f30ec9007
e22eb0578a550d8770500615cbbdd6562abfba11c7e071bbde4b4a379bcdae9d2f41ee3fd607567fc0eb8f0eeafe6bad19ec1e5ccfb8f0bbde63d2e0a84c9070
0471570c55ae7185e291a7fdf62b7f9ff6febf9f733f6d72e83fab4108ae414028d5627fea3b75b5de7f15baf7c768efab9ec3e6ee5844d1240904354ab7dd1d
69afe0fae74ab7bfdbc8fdbee03f48a3c58c1050642ac851cfd3ebc71f08fb8387219f38922b592cdb34ff568a97cd6b34ef37097ec55df53fd455ec4bedf33f
d43eec4baeff7ea3eb57ec0453dc80e6a5aad096cb34a55716ea2720e88654235d053ad42e823dba41273cf1f6b1c637dfcfe27b60a22f80c5d0c468d570fc6c
efdfd0e9968bbd2ba0a830ff0602617981e8ceddbbbb6bee9dbe6b549617acc24d63f0dd28ba2b75e154dd9875262bcea452974ed5bd67b2c641dd18776750dd
5a6c02bbe6debbb4e87567f2ddb87fc60f283612a43e86c9540171aba57d32602414080a4993a93e0605e3f1fffffffccd3c20b09adb9d54b6df9f68de47b72b
a85ceaf2ecf12068d4816498eeacb261f9c97dc97db03964112b51a1d2d9b8618bfb83c7a0914316a172bb82caa5ffe716bbd5e1ce2a1bb6cff0cd3c20b09adb
9d5486111ff3393a90abe5922fa8a3fdf5b8ee626945b66249bde6c23dd4caee9e4b2dfa55a2d4f2235ac9e673b17765bdd66c3e176abfd86dbdd66bdbea63bd
9575a47db4965a634bd646fd77a4dc5b49bdba446bbd77bf176bb96cbdd86bb9ee63bdd86cada6dee2ea9ebbdf663dc1e6ea69a9d673df63bd178ba925a54b12
01462341441a8cc501804d56c1d81986aa1371681980a9b010018f841984844f5702f84c84c3153018f77dbbbdfde1b52c0a1ee985fe197f332cee0c03979731
23bfd7c9bb4599aabae689e52ec839fbfb196c5d017e64550c3f41ff8799fb3aafcdc885ce01c50467897628582fd6456a7ed7d494a4be1bf695b6ddd2440d4c
6613012254ae49498458aa25924152283904e33012020c6294cc1ea2d837c97e83dc6fd2ed1fc27fc75e8a3fe8a62ddd1dc2be93a6c31d7c958b3c3b80e628f3
c2cf875e8a3f7431177856326a22f0cdfbe30be7d3f94b863ecacd169d487314f169e7c3274d973ae8a62ddd1dc2be93a6c31d7ca362bf61fe8769b7eb274d97
0c20c24974214054e1d81907496c5a2522b201944e8aace598721f442c139c7737017753ccf47727d5ccb410dccd3223a2f7e2931935bf9be20e17dfbd4990bb
bb187c7713c37937017713b18bc1e34ee5ffe1ffbb186f4a34fd7f3731dd9c7713b1187f7712a070dddd9b749b90102c8b64935173e2934e45cd4cb229ee2695
cd4ce60e17df8cdb1bbeb725c3a7ed4cda098b0250ab068e4e14ec3e79853dfca83399623f440576c4dd8dc26b50ee3d6d06f21f3e16732875fa881907b91cba
7d4c878dd4ada45fde987190bbd4e5dbfa57be1eeedbb7e5ce1e0f6ceddbcae6076f1b9b3c1ed8dbc7d39d3cadb492cf21ace73d95f4adb692cf2179f1405a7c
4b4d8b6fa979f140daf440dae43d657a96ba353cdda687b7dae46d634dde36d6f4404a381c9202de5342d16a4a380cc44000e2e0c29e3f4c79469033192bb045
ca71b1b754e82c70a1cbffff8846929378c9dfb15ecd81bcbd72f8c50d4e5310140a478ed74f22c18c645d803c748b7c23d93cfe3cf61ed93cfe0b75e1f67ccb
97ebb970d83bcac326c1a32632a69a0dbff58b7cb31a0a93dde478fd2412cc48d67517e856b378ad38f60fd85b6477f0fb06eac3fdf8873fd763f0b17685874c
83474864fdaf47e3bfdb16cc1a016e8411d1b0a1384211fc9c98ba539306bcbcc5cc9d51c42e2cd893559e40e9c4a9c4149bbd9bcd261d46a6e21cba0ca7a8ca
10277bd1e93c7cfd81a4bc5a58fb972eca89cbec951397c9da9e3f5c05fb6e2758ff932ed2f0e26be2972ebaa7c7ab9df849b671b32a43f449b613eee81b225e
a1de1a27be674d00c8a34f00aea30fb664f1f33369a197fcd1d6f4127d1d5d3f5c85965e7d60fd828d639f577c7d47648ef6828daf7182bd337774e56808117b
8cc5abcecca11d7b5608d1778c53abf889b657dd491c81b84a292212d0542a2234021242a9a449944e4666a2f8642c7170441e4c50c058142052f0d812804e05
743e0b42915018dfdf922a7c1b6ffbeedb47ebdf2e75fef11b1ae34d76af79c3b6ce92908153c54be52f4a5f5c85593302e1311c4c0cccc669e9734b988a7762
3f68d1090c80865b4ec6366fccf868a531e5deb3eff8bfa62aaff3b7e9edeaf9bddb1fb3cef05c02444c3b54ff83578475c2d055fe125fc17bb40e521eb260fc
4193279a2b5c5498a27fa866189bb55dbbd1480890365bfbc266f599e6c74b10db0c7d18a05020594a2853a5804046c8aa4773dddd3c771cd0ac7a1aa4a955d4
a3256a6a333580608a7f777777cde6112b1f78ed0c823034d5ddcd0334ddc574d57f4d6db2feea6a4a9a0046b7bbbbdddd0c63e563d7ce00eb239abc8be6ea7f
77a77a1a97647ad72023f7ffffffffffffffffffffffffffffffffffffffffffffffffffffffffbf6496116ca447c84d1f2919a2964d4d6c954cff86753bb06f
81e53c2c3163ff41db3db0afacc9f2cb754d4d0db3fd0edb89f50b2ccfe100b7ff8b5e1fc16679ee2317a9f5259a7a2571e159f2045c2e89ce9658db138107b7
67f67e7d3dff53a17438d5080420f3614596ba28fff670bfaf182a05ca182b083e5c6d8ecbd5acddd5278bce65d6179d7bb263cfc2bd0933f793db763eba977c
fd6cdf09bb63c84ddc9b31733f8927f1d18520d7cf06fc7166fefe46c6ad999b2e667ec8cc61c0f304a40c2113ca912ed2fd0d0bf695380ced17816ddf09b886
dcacdccf6e5ff9e8da7ef1f7b16f24cead3335733f89e7e96200f9f781335c9dbbbfcccc61c0f304a40c2113ca912ed2fded66060bf69528653f886c7bce48b5
6437336765e6acccf97f9df695a8d7194f3ae1dfd3dbbfeabffdabf09ef32bfb09577295fd571825655504eadbbaa2ab73bf6b3fdfefde5fde3dc6bdb76bf69e
b1b6f7bbd6f6966c9d6bbd662f19fbdd6bbddf9db747d0fdee3f6b3f08b1c6dc0b106b6dbd0260c6bd660066dd7ee6fd2857e5dfd3bfea7a25754f9a42c9ec5a
37392955a429e4abaabefd4abe0a73e67d0030910600f6fdca0060b40030e76900b2fd9ab77fd7fd10f54daa8ae0ab5ad57fc75055a2aa20baeabffdbbee8fd0
5fe5dfef3f7b00fd5ddfed6e00ed5d7ddfa910cbaafa3700565db5eccd00f66fde0c00bd260060ff960030d68800b1c604000102030101040502060105030607
0804090a0b040c0d0e050f1d001601090b1712130418051906191718061a181905121a0b0f1b1c1b0d151e2f002c2122032d2422052e2426032f272816202629
0a262b290c25262113212d2e0f3c30110a3d3231031e100a1f31343516323738191308371a3434361b323c3d1e324f4011021107120501030402160701094602
070449030a041c001d061f0c1d171106191812340718450309130718081a381a09123a120b1f0c1f1b162e111f29112e122a242312292427062b4724182b2628
19272b2a1926262a11213d201e39203d113a123a111930101a3137191213080817344f4510324c361d4247481942474a18020102030104050602070809010a0b
0c030d0e08040b0a0c051f10011212030516141506171514061517180913181709151a1b0c181a1b0d151e2f000924210211212304012e250606220703222829
0a26280b01240c2f0d1623220104290507222c2403141f2e002a2e3f00292f3e000a210b020114020502070d08013a010b083d020e043b010a0b3f1300123214
03163415051c3515041d371608183816071b1a1d0b131a1c0b1d3e170f0904260111112003013e2205062229072228270926282a0b243c030f16332402042926
05222c2d04143f170e2a3e280f293f280e3a393a0b3e3b3c0d3f3e3f19304a301c313e3b1d32393f1a333b3a0c3f4e301f303a4f10313e391bc2018a24b1b040
6cf52352294babb511044c2ae459a435401962290a426631404028733144014ce844280c285212140e4c6783f87c48e5c2d86480c79351a8b294a56475f695b9
0299adc09a3ab913a7c3cb791ae221a6bbf445e99ac3a6fffc0e374c74bd83ea99c0ad9e0d7bbdf5067cf711ea65fb23bbf5df56fa3b82276300e615b166ff1d
f09e97fe8361c5d3a3a757719a17cc0776c754d934eda94fdc7b7dca06ed516759ad03554e00ae9d18d4014f71e9fe1e561b761e2065d99eb32de736c77f6cd3
2cacbe64f47dd672f6e87c0de44cef28965286028ccf90b911987ae38f3298713ccb72499eae395d822f2f3eeb9495f01766d921966b4abf369b63330a12c78e
7fff6614f73afdfd4cb6f38888d89087d9da69eb5dc2f5dedeefe795c13246ca759ece56ae49c0edd3be7e79bcbd71a8b3af7bfeede49ba4265bf3f72d8aefbd
d6aad06b15e59d35c3bd4627e7d659db6bfbe379986b65fc636d782bba6b5d708bd45b4a32e895b3d6e7b79b6b45b7e8833ee8837ed6cb7f37c6ca8f85c1177c
f1975bc85ff8d6df25c7d2ca4afadc49e91e637bd3d74ed2a79d02e9d625b748ad3ced02bf3ce45f90c5c2ecd823972bf0856f25d780e894747d8aa47e05d41c
1c23c6386db33fdcf81af0aaf879bcd1377a24e8e090e37bf309f702ef283e3ffcfece8aaf31fa527716a40ef9350902255c9fa347aeb0e8fbfe4e6705d790fc
a97567551b17cd5a7f2fb3dd4fd27591e25e70297bdcb2bba28d8bee355a7f9dceb4c879c4238b63fd2403e3582526a633e067cad25367a4ad545ce7455b8d1b
cb3800fba528ff67261b5220273b3574bc287627e8ea08cc4eb1c22d9a7963aa68b52d9a79db136c25383d7982139d2738d179db136c35b6c156db13cdcb00af
455e081b5d0a50e8bcb9e539926bb2234951c49b14452349e13992149ebc10ba6fbc10a89f8710a8be04b0d1bc6c5f9e3579db135d3aa7a89f87edaadf2b7faa
f8c5dbaeb2dab12d9a7fcf0aaa65985b45da2138d169207c9100aa9906a21a09b03d79dbd362b54d7579db549737c66556db546635a68a56635c9706139509b0
3da552707afe9f5b9eda31f6db6585b03d79635c9727382d463015be6930fe5579dba2f9f7dcfaf4fd2f78e7c3a3cf9ebff9e0dbcbef7e3cfaecf99b5e6f3fbf
e9f5ecd98f5ecf9efdf8e0dbcb7f3e79bd8c7cbffdeeff9bd15ed14e475a2149a2fe823e19fdc18fd2bca6c827fffdffcfebe5fa2fbc1d79baa2a2bc5eaebcc2
2b4f56aeaca82b9fa72bbcc2db91a72b2acaebe5ca2bbcff79bc1d15ffaebcc2fb6ef5f254f78fbad256ff562f4f15ff1965252bbc1d79baa282bc5eaeacca2b
4f56aeaca8239fa72bbac2db91a72b2ac8ebe5caaabcf2ff9f152f9ff759951436cfd7158cc29136a9ba454af732ac3a9a8456325a55a22dd85ea12f015a09aa
485a2143d47eed74430195aa0bb5e9f7ffff1d79aac8fbff1d79aaa882bc5d6495a7338ebc5d544156ae3ac2db91d191a78a2ac8db4556793af274df54414657
809ff7793afe822ac82e4b74959fa7c33a2aa8c3a8829b95e1e5c82b2aa8824f1554515664e5c82b2aa8825e4115549515793ac28a2aa8a3a8822aca8abccffb
2af859f11d750fb5cc7b4975a93ac92aca27493a56824d459645771545e818100328043421a240022910212e2102612202240c282e8102a222222023223ea342
40013080421013220a2190321152022919213ba34210222f30291e10222f302922f2629382222c202e2e450265e2542d592d55284085028542d5925527502743
6303d373047344303739303620e38304e3423a403c2ed4c3c5e3523e60302e160307236231663c2816c307e3324430462ed304a424334c04248334a3840130c3
4410324c534025b344f38401815624000a5f2d000a1f61400272f0e00372f0003636000b3f3e000b1f60830431908364319010262c10032f4010030f80364800
0a4f4c000a0f608304a0f05504a0f00168c40431f0040231f000464c10036f2810030f60e50331f0610531f0007220702a18007220732a1510225a205c8e6628
10032f5e10030f20240544e5525250542e546515855256605822e53506e5342e3e2b3e234633626362e3e2080c813850828402058870ffffffffffdfea2a3eb6
eae8adbe3ac667adbe3ab136a6e2d85b910e0100080a9100255ece05906fbdeaab63de3a643ed64b46973a542df4008d4000c000b0790b30d3ea2a6e2a8e6cbd
1d594cd63edcb1d62a7effffffffffffffffffffffff1f6165a2c2284495850842545951ffff4f67bdfb741dfb64fdffff0ba869d3684ce10c75ffff1dbd67df
f164dfb1ffffbf9585202ad6566720d65684f1ffffffffffffffffffffffffffbf867dd581ade21d6be82bc25309955009f3ff0b419b8085a2edde6b9dffff64
c8e8d86b155b0867c2289cffff0671025028dcdbbbd6f9ff4fd63e5badd3e1b8c08508f9ffffffffffffffffffffffffffcf08c21871a6f2155714b222acb8bb
a6e28a2b0ac218bbd6bb678b404475675dc5222822da6bde0f40801964dd5b0527023a6bd84500c2d46bbd67de87015477d6fa0280aa8edd7bae0b6104692a5f
71065909b0698d2b80a008f1ffffffffff8f62a2a074e823f5566fa5a385ed9b90c545abb240fd86007c3eb1c499c6eae277004b859db79493089a4b13ef3ee6
d862d7cb9d91cbb51b7a5199b4100602c16ee10fcefe701669821c3ee20f679196361b9d5ae87c6669f09177083f3bcb70d9d91e50232d8c9279871426d3a70a
1b6aeb4461c3b25d50c1452ba03d4d2ba056a873e7ce5ab73fa275fb235a34ecdcd2fdbb1364fedd893a70d9d93efb232ddd8f2e5abb8f26db0585d2fd22b010
5bae286ca99fe08cf8e57a4687759a8d3d4d1b9d50bb4eb37051c2673451ae6704d6a7d938a869f03451aee128dd2f703ad4c7186ee95a381de1db341d1ee51a
8e3df572f711be7dfbf8a05ffeada769fe0e7bc7d9cf13e5dbcf607dfaf7ea52766e574cca4fea9bcbf4a4bb92053f2bc478d92976fb23fed1ef9bcbf4ccbeb9
4c4b6a8b5979897d212b2da92e4597d1378729d97d73184ec44b0b979d5a0985d0fa056f8b5929d97d739897d83787a637c5a48c94be98657a53dc2e24c48408
05015be4b490382940d37198984297e259d4086a2559aa17a3b97a3d0b9b8da0db94d5da1db0dac9c456ae414e1954259d9445f41205102368f30f18f3426748
e773d0a05c61c8c45298ce6dd18b631136d2fd74e0578b631136e7fe3a78b2bdca5f6e6d0e8d54d8bdebe8c1ff7b95beccdada9b9e9cda1c0bb8b173d7c193fe
e63b7db9deda9b9e8cdada9b986f59adfc35ee3884a58439dbe6d64ee85f58d7c3fbb5b99732db16f5f4f27d1ef5f4f2cfbd9cd1bf1b723b6d24af97e7bba0af
97f766ed84fedf98d3f99fb09e5ebfc62283a74a9fa3e7a9c9d0fc77ca0f869aafcd30724195d45935f508462ef9499d5563eeef8a15c7405935d508462ed949
9d55e3eeef8a35ef20a49aeb357280bc229221a9cc307241cc6aac9a7d775f24d90f2155f42f998364cf884aa4f6499c4c19d699d39e6a2b6c2948d937f39617
626d5e767c85952884877d6e90123e273b3ecaf2b3b2c317eacc21347c9f9d953ed8acfce80b8ace4417d8660629e1b3ecacfcc1d7d188e8139b951f6d711d59
e98d3d256565e4071b919565438ca0320108f7f9fff9efdfdfffed9ee5c69243c32d82b677fbf1f5b7e80d1532175eed40944419f86d2924218b464a0d434829
4019d3af74eb7fc111843207bc5f79b9863667fe96dd0250292914692d2834cc0e64cde893cd21901254bb08509102142923ad549c10027065ae9a30ca870fe7
3d0a9042600ecd7058db1cedbc5d3f6b5c494842136d431839b51d2b9ab6ffffffffffffffffd3ffdfffff7efdd3cd58cdaf94b1ff6f29ecfee9cd8634dc4a76
6bf3bff89177fc37489680e796227fbf9405b3862d24948614c95f2ff67fe11bd8dd7f5790b98fd693fc4b69368bfebb8b60f63eacc9fab90390ebeedd60f67e
b319ec73c040b15e3cbb3fecdf77039c17f8c98b2db1d3c94ff7c5866c852cab3bfffffffffffffffffcf7ffe377fffbf7ffe9af549076eccfd9bfff6f294a19
db7cc84b59429892424219fffdfdb97a049ffd39fbf7ff36d2677b61fad932524a6bfbef33e19ca49c67291bcbe08fffdf3cf1366e9ceb409b5a7cff7f638bed
7390bb189367d6f7dfcf3e1229e6def5b77bfcff2d7d5bd89166e8dcd9d1f7487bcafdf6fffffbff9defdf7f9ee2852956bffecf94df799872f7df6fb4dbdd17
42bfdebcdbddfaedb7bcb3bbfacb7f6966fe3f7bd9bddcfd7c9af157e87b3e6dd7fcfff7df62f4afc4ff9ff9cf7d4afb98f2ff351942ea7f4c293fc9ee1f52f9
eb9f7fefe7bf7efd9f3f78e7f7fdf8d17df8df871ffeff7ff7fffffec6ffffffb74379ffefce94e3f7ff5eee9fffff7d77fdffffb3ebffffbf3787f7ffaed47c
f7ffbee83afdfffe7effcfbf4eff9ffc4a4e2da4296537ee4c29cb2fec979b73e99572db9ccb2f9c33e9f6d39d37c73f97eebc597cfe94e24a1317affe228cff
ffffffffffffffff4c2db9ffff3f59f1ffffb816f6ffff7f37f7ffff3b73ffff5e99fbffff9ab9ffffffffff3ffffb5efff35df9ceeff71d8f29f721b4fffffb
7ee73befffc994a644ebff56fffdc3cf39cf4ccbfff33e3ff8dff77a4c4bffffffffffffffffcf94ef29559ef2ffff5393ff2ec7fb93ffbf1e7ffdfffef9ebff
ffc79f3caf9425f4e7c377ffefcb877fffffffffff723fffff399492ffff9c2ff7ff2fc7f8ffff728cf3ffefd78cffff3feef7ffdfaffcffffc5c5ffce224a66
f2a1742d802e528111864a540190a084354e4f809d2274461d8ed9cdc67fe587e3b77a2df2d17e9aebb77acd03aa57375d643835284a2e44fa37688bd3ec912a
44fa377854fa377877346dbb15e3b087e5fa5dfcaeff358fa280ba549717a3bb8f37fa55cfd316e1dbecd253ee17a111becd2e7cfa37a88e74fa37b86edbece2
11d5773fc9d9cfdc517df7938cfa7ecae4eaef4047fe0e43e4eaef4047b78f531453488204d2d7478650db7cc40855d3a641a30ea641274a158a14925f1a0aa3
4eb38f65d78d899ee34dc4a2f26feb7774dee016347f308955ed0d6d55ea30151daa681a9a5dfc84557a741f0d9eeaffdad1b38fa43dfb4843327af790a5eeef
011da3bb8fab30fba88ecfe9c25214edc2123a2f870bb90b870b79f4acf27e3ebf8ff9fe3e5c542fa811befb98f1ddcf6408a9fe2ed9eeef325457fd4cf8e2ef
32444efe2ee072f7111ae1bb8f1abcfb880d31d5cf2503771fa1437df70167e0efd265ee7278a5db046d108b74e4ef02f9771fa17275f7612e771fa1113dfba8
9b771fa17272f7419e771fa19984b440a11e45480b2553e2b740a1113dfbb80ed1cf6447bcf86c00315b20a6e9fc4015301862050a4afcbcd8ab6ab44a9ac80c
8a1c58a6ca2b75ac555155aa2240d205993c28b1633829f0cf0208314e1db19872010f943e98cc6a811146eaf376b949ae23bbf4247675994efd7e9d40f06d3f
c3b9cfbf0218afed7639f7f94601f3756f14307f994efd7e1ae904df778e2b3df7e9f893b5e76bc22f9f259d930751f32c746451c5955e2fd92b270e92ff48e8
c892defcf26cbf1f0da7ba107679ac38465e0c45f348e8c872defcf25cbf1f0da7fa7a522863e9ced208d8976197c7eab572e2209bef21a3031abde9f5c8b31f
0da7f97a522863e7ced208d84f4e0b14fc67610ce7bb2efb81a8c48bd55f2d2b39738d5ead4b63aa9e33d7e8d3ba34a657390be3bc3e25685d0639738d4ed2a5
b1f4cad9186ff3a149634addb3882c4f25685d9794b9ce37b965684d53390be38c179a3496dc3d8bc8f15482d694dfc84e32b3e3da1e4c769523335c48e7cd6f
dcf757c36dee48c43693b424be75ab1113b85ed2b0dafd10714b7668e9a5640bab1113c82369585dfe08b8adf23cf4d23266497d7eb845a93dbcd4badc0d98c8
97aca57185f510714b163cf4d2226e497d7eb835a93dbcd4ca9f54fb6f098af5a3e0bbe99abb382f871a56899e8532804f66425494a0945209228e2ee3d88c88
c804b85480ae43194a4c2d560498bcc0d18d9e68a09eaf6ca08bdfb7a4c41203e8aad203e89e570d2c7986f4d3d51ae375fe5a2258f015ff15ffb6fb39312cfe
5841a587650ffa5ad83eb5c3fc67d1d184eb3c3aaa958da645b8ce53c2e353d33d5278fd922ea8df3dd39ed8fda041aef9fb03ee55345959b463f6fe5c4ef5fe
5c69fe58a08125de4ed4d7672f225e587057d133055585bace13535035d0b7c034b977a146b56fab7495ffe279bab4f15e2d71f1a8fefae0a847098b7aec3976
a097987aa497a19637b2e5e6f6baf8455f56aa54af8b5fe9ca5b256cfe58b0a8eacdf9daa39bd387aade9cbf767572ac914bfa797872757969662d7d79e061cb
8b3bbfa36fe2e323f31147b5ef918d4a3b76327c3ef87c6b27d393edcf872327a35b861d5dbaa491a1a32f4b36f2b2f23274e565c8272f2b3c3274e582c9e8cb
15276cf52d91db78cefffc1abb717ee9512d6cc3bff3f0dee2c3b83ffca2137e5fe3f67f18a769e74dad6ea507717dd6049b9d8cafbf772c58f301d33978af04
1f7263b0c154e83f78d7dcfb3de09859b7b986b9f685d2f9c918dd0e3dc79104eeefee2a0d68d183059b6a6988c53c2d3c547f1477220f55ce21e40bd71b9c30
f1971c12c0f68b803430ecc013f7675abd7fa6950405300e34f97e38fdff78fefb5d1575d77f5ef55de48e0000f6f875ad63dc5fff0c00f08fdba7226ddcd7df
0d0000fff8976c9dfbff000052e4d3be4af5d7aefbff0c00b07a757faa5ad52daa555dfabf7da49a750e10ef8f757fef8ccfafef0f00abf7c7f27df488546fd5
f27d0400ffeff1fbbd747eef0f00effa1e5ff755e27944d7be7a5d8f00a69a7754ffa7af9a477d08000053f74fe754f76f000000b6ff546f547fd406000060df
3a2ff36f000000f6ade34fd72dbf0c0000a1aad51df7edebaad5530e0000d0f5dff119f5df080000a1ff1dd719d73d85000010fb86cff8df080000b16ff8dbf1
47eb0f000060bfdff7edbfbe9ce55b57b679b2c50800f6f8747ebeaa94014e840070cfe5b8ceaba5db9c129b218b00f11f8ecfdf5d424827420020453e1d7feb
__label__
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000010000000000000010000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000111110000010000011100000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000011100100000000000011111111110000001111111000000010000000000000000000000000000000000000000000000000
00000000000000000000000000001111110010000000000111222221111000001122211000000000000000101000000000000000000000000000000000000000
00000000000000000000000000111999911000000000001112222222121000011222221120000000000000000000000000000000000000000000000000000000
00000000000000000000000000119999992222222222222222222222222222222222222220000000000000000000000000000000000000000000000000000000
00000000000000000000000001199944999100000000011222222222221100012222222122200000000000000000000000000000000000000000000000000000
00000000099999999999999999999422499010099999999999999999999999112222222999992000010000000000000000099999999999999999990000000000
00000000099999999999999999999220099000199999999999999999999999222222222999990222000000000000000000099999999999999999990000000000
00000000099999999999999999999900999000299999999999999999999999222222211999990001220000000000000000099999999999999999990000000000
00000000099999999999999999999999994200199999999999999999999999000222221999990000112220000000000000099999999999999999990000000000
00000000044444444444444444999999942200299999444444444444499999000222222999990000020002200000000000044444444444499999940000000000
00000000000000000000000000999994422000299999000000000000099999000222222999990002100000022000000000000000000000099999900000000000
00000000000000000000000000999990000000099999000000000000099999000222222999990001220000000222000000000000000000999999400000000000
00000000000000000000002000999990000022299999000222222222299999000222222999990000202200000011221100000000000000999999000000000000
00000000000000000000020009999940000001099999000000222222299999000222222999990000000022000002112220000000001009999994000000000000
00000000000000000000200009999900001000099999000000000000099999000222222999990002000001299000112112200000000099999990000000000000
00000000000000000002000099999400001100099999000000000000099999000222222999990000200000999990122210022000000999999940000000000000
00000000000000000020000099999000021110099999000222222222299999000222220999990002022009999992222222222222229999999900000000000000
00000000000000002200000999994000022222299999000000000000099999000222222999990002222299999940201000000011199999999990000000000000
00000000000000020000009999990000222211199999000222222222299999000222200999990000022999999400002000000011999999999999000000000000
00000000000000200000099999940000222222299999000000000000099999000000001999990000009999994000000220000099999999999999900000000000
00000000000022222229999999400002222221099999999999999999999999000000011999990000999999940000000102209999999994499999990000000000
00000000022200009999999994000002222221099999999999999999999999000010002999999999999999400000111100999999999940049999999000000000
00000022200099999999999940000022222210099999999999999999999999000111000999999999999994000001112229999999999400004999999900000000
00002200000099999999994400000222222211099999999999999999999999000020000999999999999940000022222119999999944000000499999900000000
00002000000099999999440000000212221111199999444444444444499999000222222999999999994400000122222224999994400000000049999400000000
00002000000099994444000000000210001121199999000000000000099999000000000999999994440000001122222221999440000000000004994000000000
00000200000044440000000002102000001222244444000000000000044444000111000444444440000000011222222222444000000020000000440000000000
00000200000000000000000222222222222221000000000220222000000000000111110001000000000002112222222222210000000020000000000000000000
00000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000
00000000000000000000020000222000000000000000000000000009990000000000999000000000000099900000000009990000000000000000000000000000
00000000000000000000020222000000000021111021000000000009990000000001999000000000012299922222222229990002022222222020000002221100
00000000000000000000022000000000000211211200000000099009990099099999999999992222222299912222210009990000220122210002000011222110
00000000000000000000002000000009999999999900000000099009990099299999999999990000000099900022200009990000002000000000220012222210
00000000000000000000002000009999999999999999000000299929990999099999999999990000000099900022011009990000000200000000002012222210
00000000000000000000002110099999999999999999922222099909990999044449999944440000999999999990999999999999900020011100000202222200
00000000000000000000012111999999999999999999991000049909990994009999999999900001999999999991999999999999900002111110000022222000
00000000000000000000112229999999999999999999999000009909990990009999999999900001999999999991999999999999900001222211002222200000
00000000000000000000122299999944499999444999999000004409990440004449999944411122444444499990999449994499900022222222220000200000
00000000000000000000122299999400099999000499999900000009990000099999999999990022222000099990999009990099900001222221000000200000
00000000000000000000022999994000099999000049999900099999999999099999999999990022222000999940999999999999900000222221100002000000
00000000000000000000002999990000099999000009999900099999999999099999999999992222222229999900999999999999900000122221110002000000
00000000000000000000000999990000299999000109999900099999999999044444444444440002222299999400999999999999900001112222211002000000
00000000000000000000000999990002999994000009999900044499999444009999999999900002222999999000999449994499900011222222221002000000
00000000000000000000000999990002999990000009999900022299999900009999999999900002299999999900999009990099900012222222221002000000
00000000000000000000000999990002999990000229999900001999999990009999999999902229999999999990999999999999900022222222222020000000
00000000000000000000000999990009999940000199999900001999999999009994444499900024999999949990999999999999900022222222221220000000
00000000000000000000000999990009999900001199999400009999994999009999999999900000994499904940999999999999900022222222222220000000
00000000000000000000000999999099999400001999999000099999990494009999999999900000440099900400999449994499900022222222221000000000
00000000000000000000000499999999999000099999999000999999990040009994444499900000000099900020444009990044400022222222221000000000
00000000000000000000000049999999994009999999994000499949990000009999999999900000000099900022022009990000000022222222220000000000
00000000000000000000000004999999940009999999940000099409990000009999999999900000002299900022200009990000000022222222200000000000
00000000000000000000000000499999400004999999400000044009990000019994444499900022220099900000000009990000000002222222000000000000
00000000000000000000000000244444000001999944000000000009990000019990099999900000000099900000000009990000000000222220000000000000
00000000000000000000000000200000000000444400000011000009990002229990099999900000000099900000000009990000000000000000000000000000
00000000000000000000000000200200000000001000000212222229990000009990049999400000000099900000000009990000000000000000000000000000
00000000000000000000000000022000000000002000022221000004440000004440004444000000000044400000000004440000000000000000000000000000
00000000000000000000000000022001222222221222221210000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000022222111110012222222100000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000011211200012222222100000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000012221000002222222000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000011210000001222221000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000002000000000122200000000010000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000

__gff__
73ecb269b7f979f8f5cd233eb2b1f34ec01400a250ee1c093236486a1112391f250742d1e0149a6296a751a59f02204763c8c1b0d02602d6992c541a7a954211248a5e249608a226c04a84b6408ccb8190a6c8e571a45929a42aaaaaaaaaaabe0cea595555667dcaaaa0ab72a5ee5155959de6f82a5a5651559c765abe0a5789
4553749c568dc3984553749e16e1cc22a9b24a1386e1d412a9b39846e1d412a9bf24142372fd3d7c07ab050e934bf4f509a4250f537ecdfe534389d2134af07a9bf7adf3d4d0e2748dacef89450bd4fdef53d4d3fcb2373ee9553661c2ff9646e752caa85ffd5a74173ee95e0ff3bff1acb234b330a599be0fa5be353752f7c1
__map__
fe4af5aba5772b5c80005dd2aa55df7dd1f7d54befba0000007f5fd1bdfabf1bc000003fbe22d745f6be2d74000000dfb8defdf1bc0000037f748bfdf7fc5fe00000174bee8abfaa97d5abc972e57ad6975abab5cbad5e574b9256bfdedffb2ea88920e44392439245d2de8bfed0af739c8ce43724ae72e3fde7ff9baa224439
08e4839227df745d3eaa5f74725cb95e573ad5d2bbad5e0e492bd5fdffff56abaa97affbd57f552e9745d2aa786f7fff9be11f9bebffefaff847c7dd343fe117d9ff7dd3d74bfc1feffcdff08fcfffff7ff85d2fbeffd7455d54847deabbffee8ffef048a224302ba24290456482812274762a22b3543e20586a2ecf02d27d38
2373a97a7a8602c4d0611a19c8653f3e164571b247d190626f3499489a2833113258285c9ccc4223249249657a24919b2c7a923a5eb196923aea318c998925a1ce2b11a496b19659a8d24b58cb1c95c92d654cfa925b1fcdf5df7a925b2fc5772bf524b42c5f1c9ea49697b797bd491d88cf792476bedfc923ab7fd24742e8df
a48e8f6e3c923a3fa37e96ddfb8fee3a3db85a5b539fdc767bfd2834f7f71d9eddd13a7dfd0e3b3dee7d4fefe87fdcb4bdb8c793fa90e5ace3fb8edfe5a7b85dbe16fee7969ecdd3dc1dd134e9e18b7e7d5971bba269e7f2c09b8c7965c6ece5b913f1cb07bfde5971933cddb3d1dcfe2c1ef63cb2e30f8e6c9fc585eff2d3d9
d44aece38d4f6336fe52afe2727351fc1509ee25fd547f0198c701aa3dec639352f14d46e91f422a5ec9f176ff7d25e70999baa631a944f6318e25ffb5f9bc9c51bdf0f8c6114abec384be39309eca888c6319beac8adf18eaa3a9d1395992279f61425908c63958467913a6be9fc631c2dc21515856fea5045608aefc0631c5
64fd12d97d82c62c6b4d4393d4b427909eaefaf8c75d3bea3b5ef391371635f6a4e92f4397f5df5f5f5df5f5f7a9280bc42c61f5f5f86fcfa9280bdcf475df5ebbebebef52302c66d8ebf3e48c396d8f0f92302c6314d2e4f2460f6d1395d5f24617e336b563e48c2f6f05f5f5ebbebd7e495371d77ebbf9255d18aefafafafd
7e4953718a60c71f24a9ea37acc6315f92542c63adfe31e49509bc98c631996ec92a3db8c63537d92547bfd48764951f48cbb24a8fa465fdc951f48cbfbb285c20f77807f7ef07ff07ffc3f87efffbf783ff8307bb0a74ef0bffe0f83d7f9b53d8554c277afffd7d7a9f8d0ae14d35af5855fde1785e91f1a0234feb4d21213f
ee08790f4d3cea11abe143f0aa47c3061d8434c1e78574fc8429e1557e14e1f50a9de9ea74fce55e10d7e13d78505709d386c27f83bc3ff8785e134380c3306085ffe984ffe1e0beb6e02427060829ffc307ff84e0a7a905c542e0c1041efe7fc1fd38213a08a621a70752faf83fe0fe1ed70488634a71edfa98bff4fabd3707
dc294ff6fd585ffaf54e0e74f98569fe083e14853febd3c1f2b4fc1f4f7e7d5d2be0af0781ea15f83c3efcfab854f55e0f8f486e0c1853263e6214e154c153c2f4e13d59ad5542f0a8094f4854c27d5d384f54ca855221215536fffdfc3ae1385521429f09555f7ffff6baebd35350bf0969f83ffffaaebaf7f553f0943fffff
f8530984f4fd2a7e1053fffffffd75f07c2547d74ffffffff4c2f8f86a3e9dffffffff5829ff8483faeffffffff052087fe85fc1483fffffffc1041bff6bf820ffffffffc14a67fe87f820ffffffffd3fff87fe94fffffffe0f5e13ffc3f1fd3c7e9ffe0e15cf07fc1f9f3be7cdffeae8554c839f83f2f3be5ec1ffead042a61
397c3f2f4df2f4dffeb05f184e5cefd784bebe97ffadbf50baea5faf85f5f0bffd707f84a54d55dafd4f5fa9ffd602fe13afaa895f85eac613ffa90a9f85d7e14e17eaeaae13ffa082170c175fd53aa3854855ea0ff041d0b341753fa9dafa91fea47f041830a9820c2ff0b4cf851fe17fc177d4d83483ffffcbffaffb7fc6d8
60fffff1ffea7f6ffd5b1dfffff4fffff4a7ff041fffffffffffc0444940b05089ba893ed7a436868548922208fc604504e057e92b3d93002a53f612de4c65c9ccc8198c8b419f2e16961ee23c5e1e89b1d1391c14a534bffc512097a9f418bc64c0c7922240a049d8fac5b6db6db6db6db6f1feadb3394056d9621276d964c4
15b449c20ada24f80d6cd281432860acd516537a13244e1db361fd85dfc3205138fd1f05e422abf5f46fdf4a91cf1a127963f3778a34aa66dc939dc2498e882dcc7ee4bec3fcfc3ada7472d257f66236eb7ee3a79680dc95bfcfd69d19bbfd0d0d0d0d9891b81e371f60afadf29476334f34375a5597df852171b4375bbc137d
1bb132b7631fd9e51661ec4b9b37e347175badd6cca5ea2cd604e8e949f31f77721ad2dfacbe686e5b995c65adf30c7ee5b99fee1adf30d0d9a1b99fe8d6f984f6e1ccfc308b7cc34347f46e022df303db46fe861169a7ba57d611698fec717324430d69a34e9fe78430d69a37638b96e65278d69a34e9fe5b9860ad361d895f
3293c2b4d84e6eff430569b0ec377868e23c6b4d844bbfbe1ad321340d69909b5f106b4c87d370d69b27d307afe8d69b2cfefffafec81ad364fa47bffe916b4d967f7ffdff5ad364fa47a5f3ad69b2d23d2ff3ad69b27c5d48ceb5a6cb1c899133ad6f887cf88b7e3e396b7c43e3b3e45d6b7c41f3e26222e35be21f1d888ef8
6b7c41f3eff47671adf10f8ec45e93d20d6f883e7dfeb3fb9fd1adf10f8e4444291adf107cf88888b8d6f887c72222e35be20f9f1027477af6990f8e09d3957bdb4c83e91e84e9e5015be21f4b5f0591d9c2b7c432f93859125b9c2b7cc9f1139643d7dee7b4d96909cb219e5ef69907c70fc04cf9ede385c20f778060ffffcc
27fffff07dfbc431fffcd5fffffd3e9f70c37a7ff2153fffff5f7ea9554f4ffe5557ffffc270f85c2ae14ffb5387fffe154e15357d7aa7fb00f8fffef84e1c35f5c2afe0c03ffc7aabe1384fafae151f828ff0783fa9f4e11ebea6148fd51fe11df85784e1fafa9d59f0abf8521df0b1d4e1f57d07a93e153e157060e158c20e
a70afa0e083e15fd553b06121f483a1c1a7a0edd854e0d5507484260fb060dc1870830530aa9eaa9a0e154e0f836ee0eb05305e14a7d5ec1852f07ec2774f608391e0c1fbe1f5f83e1aba7f1a707fbfff0f83fdf7fb07e9c1fefffef83fdf7e1483e1843f87fff715fe9c27aa4df0fa7ebfffb0853faa85c2faf5f4fd60fff42
853faa852027853aa75fad54ffa984b0a6b85404f0910bd5faaaffc2e12cfae12809e52613e13e9d5ff5384ea9ae130138a4c27853c2755fc2f09aab0984c29f4f4f54f0b954c3a9f5a1521617a7d783d83d299a9eabf5f090a6a707d5d7b0e1822107c2fd4f090868707d0c2f069a608820fa47841e86d087fd8a5e0c2bbc10
a748f041edb4107fc1dbde13bed4fcf60f6da0bff07053fca69c3cfcf48708694907fd3ff07e0fbf63bfffffffff0a7c3efd8efffffffffd553d4e0f85c27ffffffff056a7a455f5eaffffffffc253cf51aeabd47fe0fffff85a7e159afaf48ffc1ffffe15a7fad57d6a91fb85ffffea4d7f0bc2756a93e172bffffd322feaf0
9d5d49e14e57ffff867fa1beadbc1f0a72bffffc3070aa0df56df7d49caffffe13f55837c1105f7d67a7ffff4feabb0783820f7d49c27ffff3f177043ee20f05214910bfffffeaeeef83ef0554eaaffffff94e13cfa7878909f53ffffccbb8bb59d05aa8b05d565831662e107ab2af50807ffffffffffffffec0afffff61cb9f
ffff7dbfb4dfd815ffffec9655ffffec0ddf5b43df606fffffd92c37fecbdffba02d5b4e7d871bfffff61c530f7f7c4ffec8f7df57a04bbffffec809fef856afe84fdbbeae002bfffd8003f7da0607bf7d3fbbdf56940a695ffd837dc71c4213f64079913fb0dfe6a7f123cbfff6055a16b696af7c01db227f63beb53e29f7df
dc48c8957ff6810f382bf744a01e40f7ebebbcc0f317555f646412ada6ffad6b5ad0f7ecbb00686ff576eda12b7dc52b7de004e37fbee3b701a15f65d803ce2bf57690d02dbd5d6e3803ce0dfed3b6807857da68040d25daabd5f7103b2edbfda40c83df5b8c803c2c5769a01a1e0103757b0f205212cbbff7c407be2c00763c
3af7da016e3c804b8aabd0ea84b0e8ea87bfdf480ad876000958f215ed025a5ad6b5fabb027436c0f7fdc04b7a12c895ad6b684abed20790e37fd5d00e2001effb00df40ed6b71c69c409fd6b69da06ffab6000007bfefb22bb2ed6d320c80f7df079681bfead900001d7fe8797eb69c760320957d901dad6afefe00000dffbe
90f7109582d6b5fef803b07bfbf6000796b5ad5fec244f8953e3dffb208191e6bfbf60016d380957fa071bf43d7c75ffc1da12c0cb2afea61e5ad6e000afefb8f3a37e87b1effba09a12fbc3b6ffad6d380000977fbe5c6fd94e87bfe81ba135a057f40000001fbe9b8af5af76bff85f13b82ff80000007f71f4fd81565eff89
be37beb695f80000007f184fdd06e84ffc75b037b234afc0000003fa187bee8370ff8eb606f645fef80000007ed1fdd138dffc75b2377c4abf740000000fd07f65bdcffc75b29df1e57e80000000fffeffffe3ad09df1efe00000000445a2a11458682185bc3a1a12b13059eca160aab0166e30f3723ec6830cdc6982a321706
d0465244e152a7e063ef892051de1b8b812811788a3013151a6b4850137991d1929b1a2977abbc18822493922979429364620ccccccccccccd79d999dabce3335e53819bcfc9eca158227b5ccf8be835857acd72d717882fa13da6b2b21644f6bc5f416aa9c45e7947e5c7e284496bcc9daaa9c45e458f9e79ac5d0892d79e76
a0b9eacfd11cc75e97a92d7179b71057e41d111d2dd316debfb42e7abf304452575e0fd10dbf276ea4abf20eabafc75f3c472dbfcc1d4957e4f814e2a5254aa10d720ae3d2bb576b62a6e154e1942d23835194aed1effadbd64496b0f286c4118f51953d179b547d6debbbcb58795a1d0466570fce22f36b0bf9f382e4f76fb3
ede823f301fca45e6d5dc2fe57369d90c4336ce23f306b6d4f51f27de8ba2f79b53d4978abe711415e97cb87829a472e49525e6d4173888774fec397a9a45d727a4d79b716accea977fd97538208e5179d6df8afcd2d3915753b639e8f0bfa9e93a29f6450805348239513e83f94a466ff959515a29dbb876562e1ff8a5e68a4
6de2b42014fc8bb5966178b9eec5c395958fe42dd14db1d6598ae1ac2d6e562584029e9176b2cec9ed60e6c7338a74b87ce5d0776f73bf9595f1941cdcf90202e2c9a48739eb2ade7b28399f707117f48739f71c677b5b9f2b2b14ce25f99ed72d6755df122692fccf6b8986e7cac531499f33dae265b3dbd605d8af41e27b5c
4f2dfd8a2ec03ba41866787bdb140d082199e3c1ddb6eeb82199e3e0686bbaf1c333c3bafa0eb82199e8f035ef820f6678775ef82079ed71e8f035ef9c7125ae3c3df7c7741c8e1ae3c7c6ee9cb61a7010d72fdafa16ce6878dd9ed797e81efbc7b6103c96dfe5e3f5c68456578fae24b6ff2f0fa1f5e2c8cd78e1b7f97a38d7
d60b3eb420f6dfe5e0e686abd9ca81a3db7f97a0fbed7538fa21b7f97a071a1158a633461b7f97a377ebc3f894f5a21b7f97adbeb03f6eab654030dbfcbc35f55dfc3596460892cefe525a1aaf947ecb3e8449677f292b6115868facac7f2b764b3bf9bf6bc3ff3cdba50792cefe5eaf1b03f25470d65938dbfcbd5e3d7353d4
__sfx__
b0a84e7d2aa3232b411a7162513526767307771de773fa300cc003bf7716f341af162d50730a47374670521433d7603a672ff672e96016e363e8473f8743ff750333000d672e9603ab453b3652d9723647106c76
b3b4aa13307771de773fe5433d713c571277772ff0632363180703da672793507b5523766319033833336d21025172ff103cf763db771b9613bb063f7533f7771f2173f412036772337336273177512bd6007e04
0ea097591f2671fc363d9533f3621ef0325a573496530b542846217f270182513417033422062310561015330e40617c7121a753c902398202e1610277238c712054332b002670138627048631f31329b070a733
6c78e5f60d6762bf32033421cf730f12521c60265310995515d433e97126e510d13708464175441a725386073a464020532df1225c153dd202e1610ed5118e410440736615257203672139a7718510202710cc54
55e43c7d0342513b771b96101d07074760c80439717102373a745141303d5663ed551c56610a3430b0724d343f0043fb5200a0435b341af162c9302303429d331ff26156473af042bf6035e070a706348233f353
87ddce152e23317b342154733c522a8003c4672e233153271bb711562515525155251f50030f5107e100281531537384251d5320237604b44294023771705625273733cd04178113a75235d233c26437b422d022
7465f60e02d660f66118c35298372cf47333201e55428f6216b33107363d6042912133737384251c3630b3663894606f4307073133150af761ee370b8462da352dc011ee270582213d641ef26171070c77036263
a82f9f2f3a75715e753d87614571185432d5120c770366231b334358622f3730bf453b17507d10300731e15332453192620ac170fd152ae151a6041287518672281040f0033e845177661901537d7105c220b154
54a4a7a21d441060560a4170fd152e643246012dc4602a3704200337102df60369343921537d7105c220b15428630243773c1270c1172b943097661d7573a3572ed770915532167254360a87534e772d82209306
c1047aa31e70416901376140af110e67404a22217053fe2639a2716d563ff630112524a02086720fd62214373d5101f2111f067104342a6333cf333e8501d77737b422ac31016110d7401a1142e30339c0721c37
fd3aa4e10e5321c9572b0271d87337b422446621e711b911039672f731246012af6038c61028053b0670c06403e7715f331a817085773bc3624e302a2333d7630503214924272530cf103ff570fd16181520e543
2b38d135119730b2673436125164379743325106636169670dc772de0502e03054441a53638f63149632b04713e7422a7103e6015c353866526a003553303a4530106216200997526131157622ac622270413844
f3b890fb2d40636971388351f7572d90637f713a9712f11113a630c7622a255155551c7712476112b73330161eb243e2551bf061b97421774208622ff1125c523b03537d042273225c212d452233330603200121
bc5952ca266542b4573e84725402010150af263040020f6432a251f67138a013bf020ff213de7134d721a41727742006700646616a2238f6714b611d1703cd6222b74297450bd1220c06295701d74405b6526621
b1f44c3c0564107c531d65206b560eb76253032ae600fb73370353753704d2515151199652ea160cb7628b512aa5205a3038c13118251a2132293227e722d430218412b1430b8103312121e120982213a742fa52
936873623dc052b870258171f707339223b2570054214f200a9710f53609a6738336309602e30731a3518752299752d74024d423bc5112443024052505004f0608e431344102636324610df052aa053d05533752
40b75a1a0345106851349552ad050f45605f46112201e6232b92121a24364120f0303ad240c9341040223f16110451190017653194273a10102d6538333393001640429912334450f2032734229863391141a912
b23cbb681be42058102440333574142331b332337072111408d1309b722e156359571023535a571023535a571023535a57102353f6533ac763bb16114351c2541c36322b13175570535337167111532cf5733233
d231f2ab359453375202e530ba533972530e342f3230c2672aa4522d713ad27079542da303f4472461625335033213bf352a2022bd253bd252b6623a5722592101e7215d761696235a463da3113d2616d141f863
d45a86f9219503dd56153733513121a733513121a733513121a733513121a7334d24262671e5222626729f500cd471333118e0034d640984012c0728164009532692004750262460cd471435506e471435506e47
83c9e97514355062672aa4523d371a2343e4252c5030fd633ad1225335033213bf352a2723a8162e0522d337059342cb333a765081631ee311257027c2214f1009f4635102323571d1443c871172150f43225a25
f555ef3d208173a565081631ee311257027c2214f1009f2616e4119f073e5721ef552d9331b76636e552d9331b76636e552d9331b76636e552d941276262cf502f31626b63386742e4510bb0031f7018d270f245
55f655f627b6337b712ee2737d523d6652af7617c632dd562f5553ad5516b751b76636e552dd131b0230fd3511f07202671f53505b543c16537e243eb47396701ce330af6332f7233e31271720e7651ce5339037
db6d98a7170662ec473e53136f223df423f1561f95517a3725e5634f633ed3136f223cb332a83717c16198300a50216f5203b723c6532f0721f3721f3622b66636e552d9331b76636e552d9331b76636e552d933
db6db6db24933176062233103a03342071ab663f0051521716014263773fb331b76636e552d9331b76636e552d9331b76636e553103609b5615954159251542705465015351054600977030023433120b052d933
b6696c9c2d9331b76636e55310361170111c732ff071fc730432406d071140111401114011b46636e552d9331b76636e552d9330c74536e552d9331b76636e552d9331b76636e552d9331b76636e552d9331b766
666666662a4201d50417105159251542705465015351052514711052042ba422a8560a85302a7220e52282522a3503ae101646611401114011140111401334133341333413334522231222012220122201222036
fda666662613617d141646636e552c16505c042a55001962358102472000f7309e3404c2033d061b766366560d406231100431211460305230e6161822422041336560495723f7105844261362613636d673ff37
2aea09fa2613524455303771a84719e4119e411bf373ff7536f4119e41192160db12224733f955378403df772894008a4008a7523c373db12224733f955378403df772894008a4008a7523c373db413362634142
1cc2bce114421351203d3500a8530723603e130a822150440a0273ec301bb7302e610fc0236f7620e32039463dd5328742038463dd00363302cc55342522d35036e45108401b10436261073030c24006a001ca70
a1c033031b77621a271a8022a55030c130b867096070c4320521605d67073013270222d641c253190601db0121b05083362cf300e8300353324521001251c00631d000f805042012ea2010c67084040a84601d14
98e6118120c5220a4238804223413327610b610826502b230623626136275761ff773f95526136265262e1740717021104035133341333c332ff773fe66334133301305f5136d201dd0216d55224010b04616c14
332d30d31080513c0103b41179613b0660822415d4329961380463875513e0103b4110101356012fd042186610c0326d652164310c43056460c8640cb640ef753fa773fb230cb640cf742211202421246630ce11
6ec866ec0d4033bf772ff570c9640cb64312360e7610c8302e9443094624513365140761421c5132250202520e003388042f704081501d90512110172070c8040db65030033303730a351ac14181160df410c830
f7ffdfe206276083362cb302e9442696606276083362cb302e9442696606276083362cf30108161081010074138302c8552241237f67232470fe7536b4008a4008e60227733f9552241237b4705a41199401e712
f25e4bc92241236d3408373060621977302902159251542705465015351052514721355201d5043f0142062514721355201d5041710515925154270546501d50364442ad3112a171e554097472f42224b6317a11
85d85d853957225876257673df751df671ff653df751df671db752ef3737d533de652ef76375573ae241b61104f073c47413824313630f51104f073c47413824313630f1141757021a273ec3010b571f41428765
eefc3fa91876505a451dd20163621bf70319763dc34126520bd44395721c8623e7730fe1638b773fc7023f211fe3431b673f57107f073c7370ed461d753272272ef6113b5305f51330153fb213ef7603f573f670
5f6afb573e1453ef7603f573f6702eb67330153fb213ef7603f573f6702eb673fc423e1453ef7603f573f6702eb673103609b570a004322062bc1033e0414d00105522d7752ad57179553ee2536f72356672be66
e2798b361ab7315b372fe233dd522d7752ad57179553ee2536f72356672be660b2333fc7023b473e7730fe1638b773fc7023b473e7730fe1638b773bc32349761de153a6370ed461d70219561238223497127c40
e3dc7b8f02d42338212596406065007260c33014941185260c3301c9042596408425260170ce4300e541826039a000af110b06039a000bb410cc4301e5036c062bd3438e371ec161c7570f6072e76307b4337371
a774ee9d319763dc3438e371ec161c7570f6072e76121b751dc061e76121b751dc061636219b5415f741ce470fb6139f741ce470fb6139f741ce470fb6139f741ce470fb70165771fc3431b673f57107f071d753
f5de0f5d13b53371742b3312d50111451043343170111401114011140111401114512d9331b76636e552d9331b76636a6419d130d6541cf322ea073ad76078723035725a1607b72303572f7302ea0731d423b921
3333333320f271e7701496318d271e7701d90635b750c445312630f51104f070ac44223471e63209a163897127c40223471ea7617d751df671ff653df751df671ff44158222a37424a560e9222a37424e5616466
f56f56f53341333413258113ca22193651926529f52268621aa133b16636f452db1311754055621483709f6613e5527c330f7761ee752b8361796436f462db6419d232f1353577616d272f1353577616d272f135
5135aae92f1353577616d272f1353577616d272f1353577616d3718d722ce761997533e63271570ef271de563ac241b66636e552c456146642a95334d44111522502428e211281214154096052a4220494231a72
59b42dc2137372725737d323a5372fd533dd552ef55164661db732df372fd532b151257111a9721d6032805412820212420a11104e02280541282022a343922416f52276640d4022422306a013765030d330b066
0f43d0f41c76202b551af53298512ba33192522502428e210fc353d47003905347630f414117661d9210d7251b3643a17107e02283370ef451b7532c54531e553b4362cd662de5232e412ae5329d700390534763
9b8a714e3d470039053476316c25193641576534e342cd661de133627439651230262dd5036412241660de013fa522832715727341221c7150a6070e542053432722122b61139503117429c271d1701aa722ea20
676ced9d29c243847606a472f93018f132e55121b731bc063fa522832715727341220e34626b70289360e24626b70289360e24626b70289361f62510f462aa56287440f61410b273d07019f553b4362dd5036453
5a95a95a35a353ba50259153f27418a21254400210514622090141092125440025053597222f4134d7213b322f37434f760e9270b9721364636c112c5453266424a550d9221af561dd2432c461fd320d15515e42
13855d4115e421ad212925515e421ad2128a53177070c95317d46133352525616d222a5273ae67269570df271b2160df503c775257650156313b2021343159251542704c370e51104e06171051592513c6538074
33333311171050f127213430e1413324608a401e3122613622012378400da1626036221122304708a7522036261122243308e602233226536372643123611f522303506d071341333413314013c6761141333413
b42d0e631141333413334011b8343171133413330621991321001082243d57021a740e4061084027730318273e810300121104004214238463d17030517088200714339c7021a2711040062621bb412635205004
4ba89a8918a421501010b23110400ae00105620b41418a362a420009232d02002112202250b01410b36398302c85511b330da362f5131152313405354113ed603a7331963719a421ae403ce543ce643a73328b25
68db46a228a5109a421ba272fd053ce543ce64049250d9361d9362b1312d9272fd0528a5109a630db362d504352301a33311b630db362d504352301a33311b421ae40352301475128d5506d1737c413523014751
fedb6dfb2a132147511055616466114011b82406d0711863049640cb640cb640cb640c324041240412404124049640cb640cb640cb640b3312dd573ef553ed7737e763b7663bb771b76636e552dd573ef552dd57
616fbd2d3ef552d9331b36605f51388253da543ad7607872303572f7302a2752c0572f7302ea073ad760705117e430f9763c3232064600d57038661d0473a8072a42000d0000f000132502e4206c1326d5230d05
fbd2d5b41b1541ce6612e6016d0622a141f3571a933156431b7221ac620372405a7334f232d152339330a5231b9300b6503dd462a95514d362c92122d641ae620372405a7334f232d15223066343563766016031
fe0f97f828e6033e052aa65340451bd760b13512b1236c7406d5230d05215763d6621b1540d2373932122d641be4239b543977703e263e77017a473e0253c3623977703e263e77017a471bc4239b543977703e26
222376c73e0253c3623977703e263e77017a4718c132fd7536f5537f4719e4119e711fb371b74619e4119e711fb371b74619e4119e711fb371b74619e4119a312c8552241237b4705a41199401e71237f771fb16
fffbfed308373088400fe752233121136230470fe753f77708a400da540e87104807310361db400824016901363130c96434e140c12307f763ff732d713334133384508a00056460f416248640b36434c140c177
202977003341333062199331b312114212e155271701a0731682624307263210446204555303443b1203b0660822415d4329961380463875513e0103b4110101356012fd042186610c03269743432100e221d720
6db6db6d0c3601db0433410374560d4062c623072570a0041297602a0114c5300236060762074101e5135a3030a7310731200160df5003a6116c202125636f202ba55134133301319522126452b8542ad6636e55
__music__
00 28227a2e
0b 3d374632
0f 4e625d2c
09 6f385676
09 5346417f
05 16375d2b
0b 417e777e
05 7e771f28
0e 386c354d
0f 3d345110
08 664b333e
08 09411351
06 756d3a33
0d 6b1d674a
08 0e2b4e73
00 6f6d3465
0d 76274d6a
0a 57084037
03 79050527
0a 1d23761a
04 26101e09
0c 48403779
01 0501270a
0f 2a2a2a2a
0f 2a2a2a2a
0f 2a2a2a2a
0f 2a2a2a2a
0f 2a2a2c4d
0c 555b4519
07 422a2b2b
0e 2f203f4c
0e 2a2e1334
00 28023365
02 55535a77
0c 2a000c59
04 5574715a
02 4a002135
00 555d3e19
08 4e713546
05 05555c7f
06 121c625f
09 5557714c
00 273f4c7d
07 122a6e39
07 04676b07
08 3e555d47
04 505c181c
01 7955771d
00 7a2b433e
07 322a5d14
07 733e5d7f
0c 55503e0b
0a 7f632515
0c 542f332f
0c 7f182a2c
0f 6b5f524a
0e 591a2a37
01 0b33555b
0f 39420233
0d 35553b1c
00 282b3b55
0c 55555323
08 6d555518
05 1a36566c

